package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Blob
import scala.jdk.CollectionConverters.*
final case class PutRestApiRequest(
    restApiId: String,
    mode: Optional[zio.aws.apigateway.model.PutMode] = Optional.Absent,
    failOnWarnings: Optional[Boolean] = Optional.Absent,
    parameters: Optional[Map[String, String]] = Optional.Absent,
    body: Blob
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutRestApiRequest = {
    import PutRestApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutRestApiRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(failOnWarnings.map(value => value: java.lang.Boolean))(
        _.failOnWarnings
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .body(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(body.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.PutRestApiRequest.ReadOnly =
    zio.aws.apigateway.model.PutRestApiRequest.wrap(buildAwsValue())
}
object PutRestApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutRestApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutRestApiRequest =
      zio.aws.apigateway.model.PutRestApiRequest(
        restApiId,
        mode.map(value => value),
        failOnWarnings.map(value => value),
        parameters.map(value => value),
        body
      )
    def restApiId: String
    def mode: Optional[zio.aws.apigateway.model.PutMode]
    def failOnWarnings: Optional[Boolean]
    def parameters: Optional[Map[String, String]]
    def body: Blob
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getMode: ZIO[Any, AwsError, zio.aws.apigateway.model.PutMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getFailOnWarnings: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("failOnWarnings", failOnWarnings)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getBody: ZIO[Any, Nothing, Blob] = ZIO.succeed(body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutRestApiRequest
  ) extends zio.aws.apigateway.model.PutRestApiRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val mode: Optional[zio.aws.apigateway.model.PutMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.apigateway.model.PutMode.wrap(value))
    override val failOnWarnings: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.failOnWarnings())
      .map(value => value: Boolean)
    override val parameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val body: Blob = zio.aws.apigateway.model.primitives
      .Blob(zio.Chunk.fromArray(impl.body().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutRestApiRequest
  ): zio.aws.apigateway.model.PutRestApiRequest.ReadOnly = new Wrapper(impl)
}
