package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SdkType(
    id: Optional[String] = Optional.Absent,
    friendlyName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    configurationProperties: Optional[
      Iterable[zio.aws.apigateway.model.SdkConfigurationProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.SdkType = {
    import SdkType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.SdkType
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(friendlyName.map(value => value: java.lang.String))(
        _.friendlyName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        configurationProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationProperties)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.SdkType.ReadOnly =
    zio.aws.apigateway.model.SdkType.wrap(buildAwsValue())
}
object SdkType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.SdkType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.SdkType =
      zio.aws.apigateway.model.SdkType(
        id.map(value => value),
        friendlyName.map(value => value),
        description.map(value => value),
        configurationProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[String]
    def friendlyName: Optional[String]
    def description: Optional[String]
    def configurationProperties: Optional[
      List[zio.aws.apigateway.model.SdkConfigurationProperty.ReadOnly]
    ]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getFriendlyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("friendlyName", friendlyName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getConfigurationProperties: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.SdkConfigurationProperty.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "configurationProperties",
      configurationProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.SdkType
  ) extends zio.aws.apigateway.model.SdkType.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val friendlyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.friendlyName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val configurationProperties: Optional[
      List[zio.aws.apigateway.model.SdkConfigurationProperty.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.apigateway.model.SdkConfigurationProperty.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.SdkType
  ): zio.aws.apigateway.model.SdkType.ReadOnly = new Wrapper(impl)
}
