package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class TestInvokeAuthorizerResponse(
    clientStatus: Optional[Integer] = Optional.Absent,
    log: Optional[String] = Optional.Absent,
    latency: Optional[Long] = Optional.Absent,
    principalId: Optional[String] = Optional.Absent,
    policy: Optional[String] = Optional.Absent,
    authorization: Optional[Map[String, Iterable[String]]] = Optional.Absent,
    claims: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse = {
    import TestInvokeAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse
      .builder()
      .optionallyWith(clientStatus.map(value => value: java.lang.Integer))(
        _.clientStatus
      )
      .optionallyWith(log.map(value => value: java.lang.String))(_.log)
      .optionallyWith(latency.map(value => value: java.lang.Long))(_.latency)
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(
        authorization.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.authorization)
      .optionallyWith(
        claims.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.claims)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly =
    zio.aws.apigateway.model.TestInvokeAuthorizerResponse.wrap(buildAwsValue())
}
object TestInvokeAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TestInvokeAuthorizerResponse =
      zio.aws.apigateway.model.TestInvokeAuthorizerResponse(
        clientStatus.map(value => value),
        log.map(value => value),
        latency.map(value => value),
        principalId.map(value => value),
        policy.map(value => value),
        authorization.map(value => value),
        claims.map(value => value)
      )
    def clientStatus: Optional[Integer]
    def log: Optional[String]
    def latency: Optional[Long]
    def principalId: Optional[String]
    def policy: Optional[String]
    def authorization: Optional[Map[String, List[String]]]
    def claims: Optional[Map[String, String]]
    def getClientStatus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("clientStatus", clientStatus)
    def getLog: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("log", log)
    def getLatency: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("latency", latency)
    def getPrincipalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getAuthorization: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("authorization", authorization)
    def getClaims: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("claims", claims)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse
  ) extends zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly {
    override val clientStatus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.clientStatus())
      .map(value => value: Integer)
    override val log: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.log())
      .map(value => value: String)
    override val latency: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.latency())
      .map(value => value: Long)
    override val principalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: String)
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
    override val authorization: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorization())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val claims: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.claims())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeAuthorizerResponse
  ): zio.aws.apigateway.model.TestInvokeAuthorizerResponse.ReadOnly =
    new Wrapper(impl)
}
