package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ThrottleSettings(
    burstLimit: Optional[Integer] = Optional.Absent,
    rateLimit: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ThrottleSettings = {
    import ThrottleSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ThrottleSettings
      .builder()
      .optionallyWith(burstLimit.map(value => value: java.lang.Integer))(
        _.burstLimit
      )
      .optionallyWith(rateLimit.map(value => value: java.lang.Double))(
        _.rateLimit
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.ThrottleSettings.ReadOnly =
    zio.aws.apigateway.model.ThrottleSettings.wrap(buildAwsValue())
}
object ThrottleSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.ThrottleSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ThrottleSettings =
      zio.aws.apigateway.model.ThrottleSettings(
        burstLimit.map(value => value),
        rateLimit.map(value => value)
      )
    def burstLimit: Optional[Integer]
    def rateLimit: Optional[Double]
    def getBurstLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("burstLimit", burstLimit)
    def getRateLimit: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("rateLimit", rateLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ThrottleSettings
  ) extends zio.aws.apigateway.model.ThrottleSettings.ReadOnly {
    override val burstLimit: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.burstLimit())
      .map(value => value: Integer)
    override val rateLimit: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.rateLimit())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ThrottleSettings
  ): zio.aws.apigateway.model.ThrottleSettings.ReadOnly = new Wrapper(impl)
}
