package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAuthorizerRequest(
    restApiId: String,
    authorizerId: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest = {
    import UpdateAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .authorizerId(authorizerId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateAuthorizerRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateAuthorizerRequest.wrap(buildAwsValue())
}
object UpdateAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateAuthorizerRequest =
      zio.aws.apigateway.model.UpdateAuthorizerRequest(
        restApiId,
        authorizerId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def restApiId: String
    def authorizerId: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getAuthorizerId: ZIO[Any, Nothing, String] = ZIO.succeed(authorizerId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest
  ) extends zio.aws.apigateway.model.UpdateAuthorizerRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val authorizerId: String = impl.authorizerId(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateAuthorizerRequest
  ): zio.aws.apigateway.model.UpdateAuthorizerRequest.ReadOnly = new Wrapper(
    impl
  )
}
