package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBasePathMappingRequest(
    domainName: String,
    basePath: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest = {
    import UpdateBasePathMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .basePath(basePath: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateBasePathMappingRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateBasePathMappingRequest.wrap(buildAwsValue())
}
object UpdateBasePathMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateBasePathMappingRequest =
      zio.aws.apigateway.model.UpdateBasePathMappingRequest(
        domainName,
        basePath,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainName: String
    def basePath: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getBasePath: ZIO[Any, Nothing, String] = ZIO.succeed(basePath)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest
  ) extends zio.aws.apigateway.model.UpdateBasePathMappingRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val basePath: String = impl.basePath(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingRequest
  ): zio.aws.apigateway.model.UpdateBasePathMappingRequest.ReadOnly =
    new Wrapper(impl)
}
