package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateBasePathMappingResponse(
    basePath: Optional[String] = Optional.Absent,
    restApiId: Optional[String] = Optional.Absent,
    stage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse = {
    import UpdateBasePathMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse
      .builder()
      .optionallyWith(basePath.map(value => value: java.lang.String))(
        _.basePath
      )
      .optionallyWith(restApiId.map(value => value: java.lang.String))(
        _.restApiId
      )
      .optionallyWith(stage.map(value => value: java.lang.String))(_.stage)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateBasePathMappingResponse.wrap(buildAwsValue())
}
object UpdateBasePathMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateBasePathMappingResponse =
      zio.aws.apigateway.model.UpdateBasePathMappingResponse(
        basePath.map(value => value),
        restApiId.map(value => value),
        stage.map(value => value)
      )
    def basePath: Optional[String]
    def restApiId: Optional[String]
    def stage: Optional[String]
    def getBasePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("basePath", basePath)
    def getRestApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restApiId", restApiId)
    def getStage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse
  ) extends zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly {
    override val basePath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.basePath())
      .map(value => value: String)
    override val restApiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.restApiId())
      .map(value => value: String)
    override val stage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateBasePathMappingResponse
  ): zio.aws.apigateway.model.UpdateBasePathMappingResponse.ReadOnly =
    new Wrapper(impl)
}
