package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateUsageResponse(
    usagePlanId: Optional[String] = Optional.Absent,
    startDate: Optional[String] = Optional.Absent,
    endDate: Optional[String] = Optional.Absent,
    position: Optional[String] = Optional.Absent,
    items: Optional[Map[String, Iterable[Iterable[Long]]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse = {
    import UpdateUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
      .builder()
      .optionallyWith(usagePlanId.map(value => value: java.lang.String))(
        _.usagePlanId
      )
      .optionallyWith(startDate.map(value => value: java.lang.String))(
        _.startDate
      )
      .optionallyWith(endDate.map(value => value: java.lang.String))(_.endDate)
      .optionallyWith(position.map(value => value: java.lang.String))(
        _.position
      )
      .optionallyWith(
        items.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item.map { item =>
                  item: java.lang.Long
                }.asJavaCollection
              }.asJavaCollection
            })
            .asJava
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly =
    zio.aws.apigateway.model.UpdateUsageResponse.wrap(buildAwsValue())
}
object UpdateUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateUsageResponse =
      zio.aws.apigateway.model.UpdateUsageResponse(
        usagePlanId.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        position.map(value => value),
        items.map(value => value)
      )
    def usagePlanId: Optional[String]
    def startDate: Optional[String]
    def endDate: Optional[String]
    def position: Optional[String]
    def items: Optional[Map[String, List[List[Long]]]]
    def getUsagePlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usagePlanId", usagePlanId)
    def getStartDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getPosition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("position", position)
    def getItems: ZIO[Any, AwsError, Map[String, List[List[Long]]]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
  ) extends zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly {
    override val usagePlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePlanId())
      .map(value => value: String)
    override val startDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => value: String)
    override val endDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => value: String)
    override val position: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value => value: String)
    override val items: Optional[Map[String, List[List[Long]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item.asScala.map { item =>
                  item: Long
                }.toList
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateUsageResponse
  ): zio.aws.apigateway.model.UpdateUsageResponse.ReadOnly = new Wrapper(impl)
}
