package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpcLinkRequest(
    vpcLinkId: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest = {
    import UpdateVpcLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest
      .builder()
      .vpcLinkId(vpcLinkId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateVpcLinkRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateVpcLinkRequest.wrap(buildAwsValue())
}
object UpdateVpcLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateVpcLinkRequest =
      zio.aws.apigateway.model.UpdateVpcLinkRequest(
        vpcLinkId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcLinkId: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getVpcLinkId: ZIO[Any, Nothing, String] = ZIO.succeed(vpcLinkId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest
  ) extends zio.aws.apigateway.model.UpdateVpcLinkRequest.ReadOnly {
    override val vpcLinkId: String = impl.vpcLinkId(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateVpcLinkRequest
  ): zio.aws.apigateway.model.UpdateVpcLinkRequest.ReadOnly = new Wrapper(impl)
}
