package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UsagePlanKey(
    id: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UsagePlanKey = {
    import UsagePlanKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UsagePlanKey
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UsagePlanKey.ReadOnly =
    zio.aws.apigateway.model.UsagePlanKey.wrap(buildAwsValue())
}
object UsagePlanKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UsagePlanKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UsagePlanKey =
      zio.aws.apigateway.model.UsagePlanKey(
        id.map(value => value),
        `type`.map(value => value),
        value.map(value => value),
        name.map(value => value)
      )
    def id: Optional[String]
    def `type`: Optional[String]
    def value: Optional[String]
    def name: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UsagePlanKey
  ) extends zio.aws.apigateway.model.UsagePlanKey.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UsagePlanKey
  ): zio.aws.apigateway.model.UsagePlanKey.ReadOnly = new Wrapper(impl)
}
