package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccessLogSettings(
    format: Optional[String] = Optional.Absent,
    destinationArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.AccessLogSettings = {
    import AccessLogSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.AccessLogSettings
      .builder()
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(destinationArn.map(value => value: java.lang.String))(
        _.destinationArn
      )
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.AccessLogSettings.ReadOnly =
    zio.aws.apigateway.model.AccessLogSettings.wrap(buildAwsValue())
}
object AccessLogSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.AccessLogSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.AccessLogSettings =
      zio.aws.apigateway.model.AccessLogSettings(
        format.map(value => value),
        destinationArn.map(value => value)
      )
    def format: Optional[String]
    def destinationArn: Optional[String]
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getDestinationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.AccessLogSettings
  ) extends zio.aws.apigateway.model.AccessLogSettings.ReadOnly {
    override val format: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => value: String)
    override val destinationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.AccessLogSettings
  ): zio.aws.apigateway.model.AccessLogSettings.ReadOnly = new Wrapper(impl)
}
