package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ApiKey(
    id: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    customerId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    createdDate: Optional[Timestamp] = Optional.Absent,
    lastUpdatedDate: Optional[Timestamp] = Optional.Absent,
    stageKeys: Optional[Iterable[String]] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.ApiKey = {
    import ApiKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.ApiKey
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(customerId.map(value => value: java.lang.String))(
        _.customerId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        lastUpdatedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .optionallyWith(
        stageKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.stageKeys)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.ApiKey.ReadOnly =
    zio.aws.apigateway.model.ApiKey.wrap(buildAwsValue())
}
object ApiKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.apigateway.model.ApiKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.ApiKey =
      zio.aws.apigateway.model.ApiKey(
        id.map(value => value),
        value.map(value => value),
        name.map(value => value),
        customerId.map(value => value),
        description.map(value => value),
        enabled.map(value => value),
        createdDate.map(value => value),
        lastUpdatedDate.map(value => value),
        stageKeys.map(value => value),
        tags.map(value => value)
      )
    def id: Optional[String]
    def value: Optional[String]
    def name: Optional[String]
    def customerId: Optional[String]
    def description: Optional[String]
    def enabled: Optional[Boolean]
    def createdDate: Optional[Timestamp]
    def lastUpdatedDate: Optional[Timestamp]
    def stageKeys: Optional[List[String]]
    def tags: Optional[Map[String, String]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getCustomerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerId", customerId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getStageKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("stageKeys", stageKeys)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.ApiKey
  ) extends zio.aws.apigateway.model.ApiKey.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val customerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val createdDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val lastUpdatedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val stageKeys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.stageKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.ApiKey
  ): zio.aws.apigateway.model.ApiKey.ReadOnly = new Wrapper(impl)
}
