package zio.aws.apigateway.model
import scala.jdk.CollectionConverters.*
sealed trait ApiKeysFormat {
  def unwrap: software.amazon.awssdk.services.apigateway.model.ApiKeysFormat
}
object ApiKeysFormat {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.ApiKeysFormat
  ): zio.aws.apigateway.model.ApiKeysFormat = value match {
    case software.amazon.awssdk.services.apigateway.model.ApiKeysFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.ApiKeysFormat.CSV =>
      val r = csv
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.ApiKeysFormat {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ApiKeysFormat =
      software.amazon.awssdk.services.apigateway.model.ApiKeysFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object csv extends zio.aws.apigateway.model.ApiKeysFormat {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ApiKeysFormat =
      software.amazon.awssdk.services.apigateway.model.ApiKeysFormat.CSV
  }
}
