package zio.aws.apigateway.model
import scala.jdk.CollectionConverters.*
sealed trait ContentHandlingStrategy {
  def unwrap
      : software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy
}
object ContentHandlingStrategy {
  def wrap(
      value: software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy
  ): zio.aws.apigateway.model.ContentHandlingStrategy = value match {
    case software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy.CONVERT_TO_BINARY =>
      val r = CONVERT_TO_BINARY
      r
    case software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy.CONVERT_TO_TEXT =>
      val r = CONVERT_TO_TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.apigateway.model.ContentHandlingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy =
      software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object CONVERT_TO_BINARY
      extends zio.aws.apigateway.model.ContentHandlingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy =
      software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy.CONVERT_TO_BINARY
  }
  case object CONVERT_TO_TEXT
      extends zio.aws.apigateway.model.ContentHandlingStrategy {
    override def unwrap
        : software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy =
      software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy.CONVERT_TO_TEXT
  }
}
