package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateApiKeyRequest(
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    enabled: Optional[Boolean] = Optional.Absent,
    generateDistinctId: Optional[Boolean] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    stageKeys: Optional[Iterable[zio.aws.apigateway.model.StageKey]] =
      Optional.Absent,
    customerId: Optional[String] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest = {
    import CreateApiKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        generateDistinctId.map(value => value: java.lang.Boolean)
      )(_.generateDistinctId)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(
        stageKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stageKeys)
      .optionallyWith(customerId.map(value => value: java.lang.String))(
        _.customerId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateApiKeyRequest.ReadOnly =
    zio.aws.apigateway.model.CreateApiKeyRequest.wrap(buildAwsValue())
}
object CreateApiKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateApiKeyRequest =
      zio.aws.apigateway.model.CreateApiKeyRequest(
        name.map(value => value),
        description.map(value => value),
        enabled.map(value => value),
        generateDistinctId.map(value => value),
        value.map(value => value),
        stageKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customerId.map(value => value),
        tags.map(value => value)
      )
    def name: Optional[String]
    def description: Optional[String]
    def enabled: Optional[Boolean]
    def generateDistinctId: Optional[Boolean]
    def value: Optional[String]
    def stageKeys: Optional[List[zio.aws.apigateway.model.StageKey.ReadOnly]]
    def customerId: Optional[String]
    def tags: Optional[Map[String, String]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getGenerateDistinctId: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("generateDistinctId", generateDistinctId)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getStageKeys
        : ZIO[Any, AwsError, List[zio.aws.apigateway.model.StageKey.ReadOnly]] =
      AwsError.unwrapOptionField("stageKeys", stageKeys)
    def getCustomerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerId", customerId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest
  ) extends zio.aws.apigateway.model.CreateApiKeyRequest.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val generateDistinctId: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.generateDistinctId())
      .map(value => value: Boolean)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val stageKeys
        : Optional[List[zio.aws.apigateway.model.StageKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.StageKey.wrap(item)
          }.toList
        )
    override val customerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerId())
      .map(value => value: String)
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateApiKeyRequest
  ): zio.aws.apigateway.model.CreateApiKeyRequest.ReadOnly = new Wrapper(impl)
}
