package zio.aws.apigateway.model
import zio.aws.apigateway.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateDeploymentResponse(
    id: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    createdDate: Optional[Timestamp] = Optional.Absent,
    apiSummary: Optional[
      Map[String, Map[String, zio.aws.apigateway.model.MethodSnapshot]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse = {
    import CreateDeploymentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        createdDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        apiSummary.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> value.buildAwsValue()
                })
                .asJava
            })
            .asJava
        )
      )(_.apiSummary)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly =
    zio.aws.apigateway.model.CreateDeploymentResponse.wrap(buildAwsValue())
}
object CreateDeploymentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateDeploymentResponse =
      zio.aws.apigateway.model.CreateDeploymentResponse(
        id.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        apiSummary.map(value =>
          value.map({ case (key, value) =>
            key -> value.map({ case (key, value) =>
              key -> value.asEditable
            })
          })
        )
      )
    def id: Optional[String]
    def description: Optional[String]
    def createdDate: Optional[Timestamp]
    def apiSummary: Optional[
      Map[String, Map[String, zio.aws.apigateway.model.MethodSnapshot.ReadOnly]]
    ]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getApiSummary: ZIO[Any, AwsError, Map[
      String,
      Map[String, zio.aws.apigateway.model.MethodSnapshot.ReadOnly]
    ]] = AwsError.unwrapOptionField("apiSummary", apiSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse
  ) extends zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val createdDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.apigateway.model.primitives.Timestamp(value))
    override val apiSummary: Optional[
      Map[String, Map[String, zio.aws.apigateway.model.MethodSnapshot.ReadOnly]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.apiSummary())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> value.asScala
              .map({ case (key, value) =>
                (key: String) -> zio.aws.apigateway.model.MethodSnapshot
                  .wrap(value)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateDeploymentResponse
  ): zio.aws.apigateway.model.CreateDeploymentResponse.ReadOnly = new Wrapper(
    impl
  )
}
