package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUsagePlanKeyResponse(
    id: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse = {
    import CreateUsagePlanKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly =
    zio.aws.apigateway.model.CreateUsagePlanKeyResponse.wrap(buildAwsValue())
}
object CreateUsagePlanKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.CreateUsagePlanKeyResponse =
      zio.aws.apigateway.model.CreateUsagePlanKeyResponse(
        id.map(value => value),
        `type`.map(value => value),
        value.map(value => value),
        name.map(value => value)
      )
    def id: Optional[String]
    def `type`: Optional[String]
    def value: Optional[String]
    def name: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse
  ) extends zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.CreateUsagePlanKeyResponse
  ): zio.aws.apigateway.model.CreateUsagePlanKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
