package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDocumentationVersionRequest(
    restApiId: String,
    documentationVersion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest = {
    import DeleteDocumentationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .documentationVersion(documentationVersion: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.DeleteDocumentationVersionRequest.ReadOnly =
    zio.aws.apigateway.model.DeleteDocumentationVersionRequest
      .wrap(buildAwsValue())
}
object DeleteDocumentationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.DeleteDocumentationVersionRequest =
      zio.aws.apigateway.model
        .DeleteDocumentationVersionRequest(restApiId, documentationVersion)
    def restApiId: String
    def documentationVersion: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDocumentationVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(documentationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest
  ) extends zio.aws.apigateway.model.DeleteDocumentationVersionRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val documentationVersion: String =
      impl.documentationVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.DeleteDocumentationVersionRequest
  ): zio.aws.apigateway.model.DeleteDocumentationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
