package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAuthorizerRequest(restApiId: String, authorizerId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest = {
    import GetAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .authorizerId(authorizerId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetAuthorizerRequest.ReadOnly =
    zio.aws.apigateway.model.GetAuthorizerRequest.wrap(buildAwsValue())
}
object GetAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetAuthorizerRequest =
      zio.aws.apigateway.model.GetAuthorizerRequest(restApiId, authorizerId)
    def restApiId: String
    def authorizerId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getAuthorizerId: ZIO[Any, Nothing, String] = ZIO.succeed(authorizerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest
  ) extends zio.aws.apigateway.model.GetAuthorizerRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val authorizerId: String = impl.authorizerId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetAuthorizerRequest
  ): zio.aws.apigateway.model.GetAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
