package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDocumentationPartRequest(
    restApiId: String,
    documentationPartId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest = {
    import GetDocumentationPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .documentationPartId(documentationPartId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetDocumentationPartRequest.ReadOnly =
    zio.aws.apigateway.model.GetDocumentationPartRequest.wrap(buildAwsValue())
}
object GetDocumentationPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDocumentationPartRequest =
      zio.aws.apigateway.model
        .GetDocumentationPartRequest(restApiId, documentationPartId)
    def restApiId: String
    def documentationPartId: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDocumentationPartId: ZIO[Any, Nothing, String] =
      ZIO.succeed(documentationPartId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest
  ) extends zio.aws.apigateway.model.GetDocumentationPartRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val documentationPartId: String =
      impl.documentationPartId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationPartRequest
  ): zio.aws.apigateway.model.GetDocumentationPartRequest.ReadOnly =
    new Wrapper(impl)
}
