package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDocumentationVersionRequest(
    restApiId: String,
    documentationVersion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest = {
    import GetDocumentationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .documentationVersion(documentationVersion: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.GetDocumentationVersionRequest.ReadOnly =
    zio.aws.apigateway.model.GetDocumentationVersionRequest
      .wrap(buildAwsValue())
}
object GetDocumentationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDocumentationVersionRequest =
      zio.aws.apigateway.model
        .GetDocumentationVersionRequest(restApiId, documentationVersion)
    def restApiId: String
    def documentationVersion: String
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getDocumentationVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(documentationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest
  ) extends zio.aws.apigateway.model.GetDocumentationVersionRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val documentationVersion: String =
      impl.documentationVersion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDocumentationVersionRequest
  ): zio.aws.apigateway.model.GetDocumentationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
