package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDomainNameRequest(domainName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest = {
    import GetDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.GetDomainNameRequest.ReadOnly =
    zio.aws.apigateway.model.GetDomainNameRequest.wrap(buildAwsValue())
}
object GetDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.GetDomainNameRequest =
      zio.aws.apigateway.model.GetDomainNameRequest(domainName)
    def domainName: String
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest
  ) extends zio.aws.apigateway.model.GetDomainNameRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.GetDomainNameRequest
  ): zio.aws.apigateway.model.GetDomainNameRequest.ReadOnly = new Wrapper(impl)
}
