package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.StatusCode
import scala.jdk.CollectionConverters.*
final case class PutIntegrationResponseRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    statusCode: StatusCode,
    selectionPattern: Optional[String] = Optional.Absent,
    responseParameters: Optional[Map[String, String]] = Optional.Absent,
    responseTemplates: Optional[Map[String, String]] = Optional.Absent,
    contentHandling: Optional[
      zio.aws.apigateway.model.ContentHandlingStrategy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest = {
    import PutIntegrationResponseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .statusCode(StatusCode.unwrap(statusCode): java.lang.String)
      .optionallyWith(selectionPattern.map(value => value: java.lang.String))(
        _.selectionPattern
      )
      .optionallyWith(
        responseParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseParameters)
      .optionallyWith(
        responseTemplates.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.responseTemplates)
      .optionallyWith(contentHandling.map(value => value.unwrap))(
        _.contentHandling
      )
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.PutIntegrationResponseRequest.ReadOnly =
    zio.aws.apigateway.model.PutIntegrationResponseRequest.wrap(buildAwsValue())
}
object PutIntegrationResponseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.PutIntegrationResponseRequest =
      zio.aws.apigateway.model.PutIntegrationResponseRequest(
        restApiId,
        resourceId,
        httpMethod,
        statusCode,
        selectionPattern.map(value => value),
        responseParameters.map(value => value),
        responseTemplates.map(value => value),
        contentHandling.map(value => value)
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def statusCode: StatusCode
    def selectionPattern: Optional[String]
    def responseParameters: Optional[Map[String, String]]
    def responseTemplates: Optional[Map[String, String]]
    def contentHandling
        : Optional[zio.aws.apigateway.model.ContentHandlingStrategy]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getStatusCode: ZIO[Any, Nothing, StatusCode] = ZIO.succeed(statusCode)
    def getSelectionPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selectionPattern", selectionPattern)
    def getResponseParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseParameters", responseParameters)
    def getResponseTemplates: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("responseTemplates", responseTemplates)
    def getContentHandling
        : ZIO[Any, AwsError, zio.aws.apigateway.model.ContentHandlingStrategy] =
      AwsError.unwrapOptionField("contentHandling", contentHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest
  ) extends zio.aws.apigateway.model.PutIntegrationResponseRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val statusCode: StatusCode =
      zio.aws.apigateway.model.primitives.StatusCode(impl.statusCode())
    override val selectionPattern: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionPattern())
      .map(value => value: String)
    override val responseParameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val responseTemplates: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseTemplates())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val contentHandling
        : Optional[zio.aws.apigateway.model.ContentHandlingStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentHandling())
        .map(value =>
          zio.aws.apigateway.model.ContentHandlingStrategy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.PutIntegrationResponseRequest
  ): zio.aws.apigateway.model.PutIntegrationResponseRequest.ReadOnly =
    new Wrapper(impl)
}
