package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.apigateway.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class QuotaSettings(
    limit: Optional[Integer] = Optional.Absent,
    offset: Optional[Integer] = Optional.Absent,
    period: Optional[zio.aws.apigateway.model.QuotaPeriodType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.QuotaSettings = {
    import QuotaSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.QuotaSettings
      .builder()
      .optionallyWith(limit.map(value => value: java.lang.Integer))(_.limit)
      .optionallyWith(offset.map(value => value: java.lang.Integer))(_.offset)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.QuotaSettings.ReadOnly =
    zio.aws.apigateway.model.QuotaSettings.wrap(buildAwsValue())
}
object QuotaSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.QuotaSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.QuotaSettings =
      zio.aws.apigateway.model.QuotaSettings(
        limit.map(value => value),
        offset.map(value => value),
        period.map(value => value)
      )
    def limit: Optional[Integer]
    def offset: Optional[Integer]
    def period: Optional[zio.aws.apigateway.model.QuotaPeriodType]
    def getLimit: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("limit", limit)
    def getOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("offset", offset)
    def getPeriod
        : ZIO[Any, AwsError, zio.aws.apigateway.model.QuotaPeriodType] =
      AwsError.unwrapOptionField("period", period)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.QuotaSettings
  ) extends zio.aws.apigateway.model.QuotaSettings.ReadOnly {
    override val limit: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => value: Integer)
    override val offset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.offset())
      .map(value => value: Integer)
    override val period: Optional[zio.aws.apigateway.model.QuotaPeriodType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.period())
        .map(value => zio.aws.apigateway.model.QuotaPeriodType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.QuotaSettings
  ): zio.aws.apigateway.model.QuotaSettings.ReadOnly = new Wrapper(impl)
}
