package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestInvokeMethodRequest(
    restApiId: String,
    resourceId: String,
    httpMethod: String,
    pathWithQueryString: Optional[String] = Optional.Absent,
    body: Optional[String] = Optional.Absent,
    headers: Optional[Map[String, String]] = Optional.Absent,
    multiValueHeaders: Optional[Map[String, Iterable[String]]] =
      Optional.Absent,
    clientCertificateId: Optional[String] = Optional.Absent,
    stageVariables: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest = {
    import TestInvokeMethodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
      .builder()
      .restApiId(restApiId: java.lang.String)
      .resourceId(resourceId: java.lang.String)
      .httpMethod(httpMethod: java.lang.String)
      .optionallyWith(
        pathWithQueryString.map(value => value: java.lang.String)
      )(_.pathWithQueryString)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(
        headers.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.headers)
      .optionallyWith(
        multiValueHeaders.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.multiValueHeaders)
      .optionallyWith(
        clientCertificateId.map(value => value: java.lang.String)
      )(_.clientCertificateId)
      .optionallyWith(
        stageVariables.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.stageVariables)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.TestInvokeMethodRequest.ReadOnly =
    zio.aws.apigateway.model.TestInvokeMethodRequest.wrap(buildAwsValue())
}
object TestInvokeMethodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.TestInvokeMethodRequest =
      zio.aws.apigateway.model.TestInvokeMethodRequest(
        restApiId,
        resourceId,
        httpMethod,
        pathWithQueryString.map(value => value),
        body.map(value => value),
        headers.map(value => value),
        multiValueHeaders.map(value => value),
        clientCertificateId.map(value => value),
        stageVariables.map(value => value)
      )
    def restApiId: String
    def resourceId: String
    def httpMethod: String
    def pathWithQueryString: Optional[String]
    def body: Optional[String]
    def headers: Optional[Map[String, String]]
    def multiValueHeaders: Optional[Map[String, List[String]]]
    def clientCertificateId: Optional[String]
    def stageVariables: Optional[Map[String, String]]
    def getRestApiId: ZIO[Any, Nothing, String] = ZIO.succeed(restApiId)
    def getResourceId: ZIO[Any, Nothing, String] = ZIO.succeed(resourceId)
    def getHttpMethod: ZIO[Any, Nothing, String] = ZIO.succeed(httpMethod)
    def getPathWithQueryString: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pathWithQueryString", pathWithQueryString)
    def getBody: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("body", body)
    def getHeaders: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("headers", headers)
    def getMultiValueHeaders: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("multiValueHeaders", multiValueHeaders)
    def getClientCertificateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCertificateId", clientCertificateId)
    def getStageVariables: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("stageVariables", stageVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
  ) extends zio.aws.apigateway.model.TestInvokeMethodRequest.ReadOnly {
    override val restApiId: String = impl.restApiId(): String
    override val resourceId: String = impl.resourceId(): String
    override val httpMethod: String = impl.httpMethod(): String
    override val pathWithQueryString: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pathWithQueryString())
      .map(value => value: String)
    override val body: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: String)
    override val headers: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.headers())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val multiValueHeaders: Optional[Map[String, List[String]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiValueHeaders())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override val clientCertificateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientCertificateId())
      .map(value => value: String)
    override val stageVariables: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageVariables())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.TestInvokeMethodRequest
  ): zio.aws.apigateway.model.TestInvokeMethodRequest.ReadOnly = new Wrapper(
    impl
  )
}
