package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateClientCertificateRequest(
    clientCertificateId: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest = {
    import UpdateClientCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest
      .builder()
      .clientCertificateId(clientCertificateId: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly
      : zio.aws.apigateway.model.UpdateClientCertificateRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateClientCertificateRequest
      .wrap(buildAwsValue())
}
object UpdateClientCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateClientCertificateRequest =
      zio.aws.apigateway.model.UpdateClientCertificateRequest(
        clientCertificateId,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientCertificateId: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getClientCertificateId: ZIO[Any, Nothing, String] =
      ZIO.succeed(clientCertificateId)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest
  ) extends zio.aws.apigateway.model.UpdateClientCertificateRequest.ReadOnly {
    override val clientCertificateId: String =
      impl.clientCertificateId(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateClientCertificateRequest
  ): zio.aws.apigateway.model.UpdateClientCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
