package zio.aws.apigateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDomainNameRequest(
    domainName: String,
    patchOperations: Optional[
      Iterable[zio.aws.apigateway.model.PatchOperation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest = {
    import UpdateDomainNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .optionallyWith(
        patchOperations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.patchOperations)
      .build()
  }
  def asReadOnly: zio.aws.apigateway.model.UpdateDomainNameRequest.ReadOnly =
    zio.aws.apigateway.model.UpdateDomainNameRequest.wrap(buildAwsValue())
}
object UpdateDomainNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.apigateway.model.UpdateDomainNameRequest =
      zio.aws.apigateway.model.UpdateDomainNameRequest(
        domainName,
        patchOperations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domainName: String
    def patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]]
    def getDomainName: ZIO[Any, Nothing, String] = ZIO.succeed(domainName)
    def getPatchOperations: ZIO[Any, AwsError, List[
      zio.aws.apigateway.model.PatchOperation.ReadOnly
    ]] = AwsError.unwrapOptionField("patchOperations", patchOperations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest
  ) extends zio.aws.apigateway.model.UpdateDomainNameRequest.ReadOnly {
    override val domainName: String = impl.domainName(): String
    override val patchOperations
        : Optional[List[zio.aws.apigateway.model.PatchOperation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.apigateway.model.PatchOperation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.apigateway.model.UpdateDomainNameRequest
  ): zio.aws.apigateway.model.UpdateDomainNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
