package zio.aws.apigateway
import zio.aws.apigateway.model.primitives.ProviderARN.Type
import zio.aws.apigateway.model.primitives.{NullableBoolean, ProviderARN}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Blob extends zio.prelude.Subtype[Chunk[Byte]]
    type Blob = zio.aws.apigateway.model.primitives.Blob.Type
    object DocumentationPartLocationStatusCode
        extends zio.prelude.Subtype[String]
    type DocumentationPartLocationStatusCode =
      zio.aws.apigateway.model.primitives.DocumentationPartLocationStatusCode.Type
    type Integer = Int
    type NullableBoolean = Boolean
    type NullableInteger = Int
    object ProviderARN extends zio.prelude.Subtype[String]
    type ProviderARN = zio.aws.apigateway.model.primitives.ProviderARN.Type
    object StatusCode extends zio.prelude.Subtype[String]
    type StatusCode = zio.aws.apigateway.model.primitives.StatusCode.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.apigateway.model.primitives.Timestamp.Type
  }
  type ListOfARNs = List[ProviderARN]
  type ListOfApiKey = List[zio.aws.apigateway.model.ApiKey]
  type ListOfApiStage = List[zio.aws.apigateway.model.ApiStage]
  type ListOfAuthorizer = List[zio.aws.apigateway.model.Authorizer]
  type ListOfBasePathMapping = List[zio.aws.apigateway.model.BasePathMapping]
  type ListOfClientCertificate =
    List[zio.aws.apigateway.model.ClientCertificate]
  type ListOfDeployment = List[zio.aws.apigateway.model.Deployment]
  type ListOfDocumentationPart =
    List[zio.aws.apigateway.model.DocumentationPart]
  type ListOfDocumentationVersion =
    List[zio.aws.apigateway.model.DocumentationVersion]
  type ListOfDomainName = List[zio.aws.apigateway.model.DomainName]
  type ListOfEndpointType = List[zio.aws.apigateway.model.EndpointType]
  type ListOfGatewayResponse = List[zio.aws.apigateway.model.GatewayResponse]
  type ListOfLong = List[Long]
  type ListOfModel = List[zio.aws.apigateway.model.Model]
  type ListOfPatchOperation = List[zio.aws.apigateway.model.PatchOperation]
  type ListOfRequestValidator = List[zio.aws.apigateway.model.RequestValidator]
  type ListOfResource = List[zio.aws.apigateway.model.Resource]
  type ListOfRestApi = List[zio.aws.apigateway.model.RestApi]
  type ListOfSdkConfigurationProperty =
    List[zio.aws.apigateway.model.SdkConfigurationProperty]
  type ListOfSdkType = List[zio.aws.apigateway.model.SdkType]
  type ListOfStage = List[zio.aws.apigateway.model.Stage]
  type ListOfStageKeys = List[zio.aws.apigateway.model.StageKey]
  type ListOfString = List[String]
  type ListOfUsage = List[Iterable[Long]]
  type ListOfUsagePlan = List[zio.aws.apigateway.model.UsagePlan]
  type ListOfUsagePlanKey = List[zio.aws.apigateway.model.UsagePlanKey]
  type ListOfVpcLink = List[zio.aws.apigateway.model.VpcLink]
  type MapOfApiStageThrottleSettings =
    Map[String, zio.aws.apigateway.model.ThrottleSettings]
  type MapOfIntegrationResponse =
    Map[String, zio.aws.apigateway.model.IntegrationResponse]
  type MapOfKeyUsages = Map[String, Iterable[Iterable[Long]]]
  type MapOfMethod = Map[String, zio.aws.apigateway.model.Method]
  type MapOfMethodResponse =
    Map[String, zio.aws.apigateway.model.MethodResponse]
  type MapOfMethodSettings = Map[String, zio.aws.apigateway.model.MethodSetting]
  type MapOfMethodSnapshot =
    Map[String, zio.aws.apigateway.model.MethodSnapshot]
  type MapOfStringToBoolean = Map[String, NullableBoolean]
  type MapOfStringToList = Map[String, Iterable[String]]
  type MapOfStringToString = Map[String, String]
  type PathToMapOfMethodSnapshot =
    Map[String, Map[String, zio.aws.apigateway.model.MethodSnapshot]]
}
