package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{TagValue, TagKey, Description, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateApplicationRequest(
    name: Name,
    description: Option[Description] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.CreateApplicationRequest.ReadOnly =
    zio.aws.appconfig.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.CreateApplicationRequest =
      zio.aws.appconfig.model.CreateApplicationRequest(
        name,
        description.map(value => value),
        tags.map(value => value)
      )
    def name: Name
    def description: Option[Description]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest
  ) extends zio.aws.appconfig.model.CreateApplicationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appconfig.model.primitives.Name(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest
  ): zio.aws.appconfig.model.CreateApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
