package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.DeploymentStrategyId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDeploymentStrategyRequest(
    deploymentStrategyId: DeploymentStrategyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest = {
    import DeleteDeploymentStrategyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest
      .builder()
      .deploymentStrategyId(
        DeploymentStrategyId.unwrap(deploymentStrategyId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.DeleteDeploymentStrategyRequest.ReadOnly =
    zio.aws.appconfig.model.DeleteDeploymentStrategyRequest
      .wrap(buildAwsValue())
}
object DeleteDeploymentStrategyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeleteDeploymentStrategyRequest =
      zio.aws.appconfig.model
        .DeleteDeploymentStrategyRequest(deploymentStrategyId)
    def deploymentStrategyId: DeploymentStrategyId
    def getDeploymentStrategyId: ZIO[Any, Nothing, DeploymentStrategyId] =
      ZIO.succeed(deploymentStrategyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest
  ) extends zio.aws.appconfig.model.DeleteDeploymentStrategyRequest.ReadOnly {
    override val deploymentStrategyId: DeploymentStrategyId =
      zio.aws.appconfig.model.primitives
        .DeploymentStrategyId(impl.deploymentStrategyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest
  ): zio.aws.appconfig.model.DeleteDeploymentStrategyRequest.ReadOnly =
    new Wrapper(impl)
}
