package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Iso8601DateTime, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DeploymentEvent(
    eventType: Option[zio.aws.appconfig.model.DeploymentEventType] = None,
    triggeredBy: Option[zio.aws.appconfig.model.TriggeredBy] = None,
    description: Option[Description] = None,
    occurredAt: Option[Iso8601DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeploymentEvent = {
    import DeploymentEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeploymentEvent
      .builder()
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(triggeredBy.map(value => value.unwrap))(_.triggeredBy)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        occurredAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.occurredAt)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.DeploymentEvent.ReadOnly =
    zio.aws.appconfig.model.DeploymentEvent.wrap(buildAwsValue())
}
object DeploymentEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeploymentEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeploymentEvent =
      zio.aws.appconfig.model.DeploymentEvent(
        eventType.map(value => value),
        triggeredBy.map(value => value),
        description.map(value => value),
        occurredAt.map(value => value)
      )
    def eventType: Option[zio.aws.appconfig.model.DeploymentEventType]
    def triggeredBy: Option[zio.aws.appconfig.model.TriggeredBy]
    def description: Option[Description]
    def occurredAt: Option[Iso8601DateTime]
    def getEventType
        : ZIO[Any, AwsError, zio.aws.appconfig.model.DeploymentEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getTriggeredBy
        : ZIO[Any, AwsError, zio.aws.appconfig.model.TriggeredBy] =
      AwsError.unwrapOptionField("triggeredBy", triggeredBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getOccurredAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("occurredAt", occurredAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentEvent
  ) extends zio.aws.appconfig.model.DeploymentEvent.ReadOnly {
    override val eventType
        : Option[zio.aws.appconfig.model.DeploymentEventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.appconfig.model.DeploymentEventType.wrap(value))
    override val triggeredBy: Option[zio.aws.appconfig.model.TriggeredBy] =
      scala
        .Option(impl.triggeredBy())
        .map(value => zio.aws.appconfig.model.TriggeredBy.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val occurredAt: Option[Iso8601DateTime] = scala
      .Option(impl.occurredAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentEvent
  ): zio.aws.appconfig.model.DeploymentEvent.ReadOnly = new Wrapper(impl)
}
