package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetConfigurationProfileRequest(
    applicationId: Id,
    configurationProfileId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest = {
    import GetConfigurationProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.GetConfigurationProfileRequest.ReadOnly =
    zio.aws.appconfig.model.GetConfigurationProfileRequest.wrap(buildAwsValue())
}
object GetConfigurationProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetConfigurationProfileRequest =
      zio.aws.appconfig.model
        .GetConfigurationProfileRequest(applicationId, configurationProfileId)
    def applicationId: Id
    def configurationProfileId: Id
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest
  ) extends zio.aws.appconfig.model.GetConfigurationProfileRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest
  ): zio.aws.appconfig.model.GetConfigurationProfileRequest.ReadOnly =
    new Wrapper(impl)
}
