package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetHostedConfigurationVersionRequest(
    applicationId: Id,
    configurationProfileId: Id,
    versionNumber: zio.aws.appconfig.model.primitives.Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest = {
    import GetHostedConfigurationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .versionNumber(
        zio.aws.appconfig.model.primitives.Integer
          .unwrap(versionNumber): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.GetHostedConfigurationVersionRequest.ReadOnly =
    zio.aws.appconfig.model.GetHostedConfigurationVersionRequest
      .wrap(buildAwsValue())
}
object GetHostedConfigurationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appconfig.model.GetHostedConfigurationVersionRequest =
      zio.aws.appconfig.model.GetHostedConfigurationVersionRequest(
        applicationId,
        configurationProfileId,
        versionNumber
      )
    def applicationId: Id
    def configurationProfileId: Id
    def versionNumber: zio.aws.appconfig.model.primitives.Integer
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
    def getVersionNumber
        : ZIO[Any, Nothing, zio.aws.appconfig.model.primitives.Integer] =
      ZIO.succeed(versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest
  ) extends zio.aws.appconfig.model.GetHostedConfigurationVersionRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
    override val versionNumber: zio.aws.appconfig.model.primitives.Integer =
      zio.aws.appconfig.model.primitives.Integer(impl.versionNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest
  ): zio.aws.appconfig.model.GetHostedConfigurationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
