package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  StringWithLengthBetween1And255,
  Description,
  Blob,
  Id
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetHostedConfigurationVersionResponse(
    applicationId: Option[Id] = None,
    configurationProfileId: Option[Id] = None,
    versionNumber: Option[zio.aws.appconfig.model.primitives.Integer] = None,
    description: Option[Description] = None,
    content: Option[Blob] = None,
    contentType: Option[StringWithLengthBetween1And255] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionResponse = {
    import GetHostedConfigurationVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        configurationProfileId.map(value => Id.unwrap(value): java.lang.String)
      )(_.configurationProfileId)
      .optionallyWith(
        versionNumber.map(value =>
          zio.aws.appconfig.model.primitives.Integer.unwrap(value): Integer
        )
      )(_.versionNumber)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        content.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.content)
      .optionallyWith(
        contentType.map(value =>
          StringWithLengthBetween1And255.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly =
    zio.aws.appconfig.model.GetHostedConfigurationVersionResponse
      .wrap(buildAwsValue())
}
object GetHostedConfigurationVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appconfig.model.GetHostedConfigurationVersionResponse =
      zio.aws.appconfig.model.GetHostedConfigurationVersionResponse(
        applicationId.map(value => value),
        configurationProfileId.map(value => value),
        versionNumber.map(value => value),
        description.map(value => value),
        content.map(value => value),
        contentType.map(value => value)
      )
    def applicationId: Option[Id]
    def configurationProfileId: Option[Id]
    def versionNumber: Option[zio.aws.appconfig.model.primitives.Integer]
    def description: Option[Description]
    def content: Option[Blob]
    def contentType: Option[StringWithLengthBetween1And255]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getConfigurationProfileId: ZIO[Any, AwsError, Id] = AwsError
      .unwrapOptionField("configurationProfileId", configurationProfileId)
    def getVersionNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getContent: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("content", content)
    def getContentType: ZIO[Any, AwsError, StringWithLengthBetween1And255] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionResponse
  ) extends zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly {
    override val applicationId: Option[Id] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val configurationProfileId: Option[Id] = scala
      .Option(impl.configurationProfileId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val versionNumber
        : Option[zio.aws.appconfig.model.primitives.Integer] = scala
      .Option(impl.versionNumber())
      .map(value => zio.aws.appconfig.model.primitives.Integer(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val content: Option[Blob] = scala
      .Option(impl.content())
      .map(value =>
        zio.aws.appconfig.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val contentType: Option[StringWithLengthBetween1And255] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.appconfig.model.primitives.StringWithLengthBetween1And255(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionResponse
  ): zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly =
    new Wrapper(impl)
}
