package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  ConfigurationProfileType,
  NextToken,
  MaxResults,
  Id
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConfigurationProfilesRequest(
    applicationId: Id,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    `type`: Option[ConfigurationProfileType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest = {
    import ListConfigurationProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        `type`.map(value =>
          ConfigurationProfileType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListConfigurationProfilesRequest.ReadOnly =
    zio.aws.appconfig.model.ListConfigurationProfilesRequest
      .wrap(buildAwsValue())
}
object ListConfigurationProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListConfigurationProfilesRequest =
      zio.aws.appconfig.model.ListConfigurationProfilesRequest(
        applicationId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        `type`.map(value => value)
      )
    def applicationId: Id
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def `type`: Option[ConfigurationProfileType]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getType: ZIO[Any, AwsError, ConfigurationProfileType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest
  ) extends zio.aws.appconfig.model.ListConfigurationProfilesRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appconfig.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
    override val `type`: Option[ConfigurationProfileType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.appconfig.model.primitives.ConfigurationProfileType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest
  ): zio.aws.appconfig.model.ListConfigurationProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
