package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentsResponse(
    items: Option[Iterable[zio.aws.appconfig.model.Environment]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse = {
    import ListEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly =
    zio.aws.appconfig.model.ListEnvironmentsResponse.wrap(buildAwsValue())
}
object ListEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListEnvironmentsResponse =
      zio.aws.appconfig.model.ListEnvironmentsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.appconfig.model.Environment.ReadOnly]]
    def nextToken: Option[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.Environment.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
  ) extends zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly {
    override val items
        : Option[List[zio.aws.appconfig.model.Environment.ReadOnly]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.Environment.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse
  ): zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly = new Wrapper(
    impl
  )
}
