package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{NextToken, MaxResults, Id}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListHostedConfigurationVersionsRequest(
    applicationId: Id,
    configurationProfileId: Id,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest = {
    import ListHostedConfigurationVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListHostedConfigurationVersionsRequest.ReadOnly =
    zio.aws.appconfig.model.ListHostedConfigurationVersionsRequest
      .wrap(buildAwsValue())
}
object ListHostedConfigurationVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appconfig.model.ListHostedConfigurationVersionsRequest =
      zio.aws.appconfig.model.ListHostedConfigurationVersionsRequest(
        applicationId,
        configurationProfileId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def applicationId: Id
    def configurationProfileId: Id
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest
  ) extends zio.aws.appconfig.model.ListHostedConfigurationVersionsRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appconfig.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest
  ): zio.aws.appconfig.model.ListHostedConfigurationVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
