package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  RoleArn,
  StringWithLengthBetween1And2048
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Monitor(
    alarmArn: StringWithLengthBetween1And2048,
    alarmRoleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.Monitor = {
    import Monitor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.Monitor
      .builder()
      .alarmArn(
        StringWithLengthBetween1And2048.unwrap(alarmArn): java.lang.String
      )
      .optionallyWith(
        alarmRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.alarmRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.Monitor.ReadOnly =
    zio.aws.appconfig.model.Monitor.wrap(buildAwsValue())
}
object Monitor {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appconfig.model.Monitor] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.Monitor = zio.aws.appconfig.model
      .Monitor(alarmArn, alarmRoleArn.map(value => value))
    def alarmArn: StringWithLengthBetween1And2048
    def alarmRoleArn: Option[RoleArn]
    def getAlarmArn: ZIO[Any, Nothing, StringWithLengthBetween1And2048] =
      ZIO.succeed(alarmArn)
    def getAlarmRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("alarmRoleArn", alarmRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.Monitor
  ) extends zio.aws.appconfig.model.Monitor.ReadOnly {
    override val alarmArn: StringWithLengthBetween1And2048 =
      zio.aws.appconfig.model.primitives
        .StringWithLengthBetween1And2048(impl.alarmArn())
    override val alarmRoleArn: Option[RoleArn] = scala
      .Option(impl.alarmRoleArn())
      .map(value => zio.aws.appconfig.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.Monitor
  ): zio.aws.appconfig.model.Monitor.ReadOnly = new Wrapper(impl)
}
