package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  DeploymentStrategyId,
  TagValue,
  Description,
  Version,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartDeploymentRequest(
    applicationId: Id,
    environmentId: Id,
    deploymentStrategyId: DeploymentStrategyId,
    configurationProfileId: Id,
    configurationVersion: Version,
    description: Option[Description] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest = {
    import StartDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .environmentId(Id.unwrap(environmentId): java.lang.String)
      .deploymentStrategyId(
        DeploymentStrategyId.unwrap(deploymentStrategyId): java.lang.String
      )
      .configurationProfileId(
        Id.unwrap(configurationProfileId): java.lang.String
      )
      .configurationVersion(
        Version.unwrap(configurationVersion): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.StartDeploymentRequest.ReadOnly =
    zio.aws.appconfig.model.StartDeploymentRequest.wrap(buildAwsValue())
}
object StartDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.StartDeploymentRequest =
      zio.aws.appconfig.model.StartDeploymentRequest(
        applicationId,
        environmentId,
        deploymentStrategyId,
        configurationProfileId,
        configurationVersion,
        description.map(value => value),
        tags.map(value => value)
      )
    def applicationId: Id
    def environmentId: Id
    def deploymentStrategyId: DeploymentStrategyId
    def configurationProfileId: Id
    def configurationVersion: Version
    def description: Option[Description]
    def tags: Option[Map[TagKey, TagValue]]
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Id] = ZIO.succeed(environmentId)
    def getDeploymentStrategyId: ZIO[Any, Nothing, DeploymentStrategyId] =
      ZIO.succeed(deploymentStrategyId)
    def getConfigurationProfileId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(configurationProfileId)
    def getConfigurationVersion: ZIO[Any, Nothing, Version] =
      ZIO.succeed(configurationVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
  ) extends zio.aws.appconfig.model.StartDeploymentRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val environmentId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.environmentId())
    override val deploymentStrategyId: DeploymentStrategyId =
      zio.aws.appconfig.model.primitives
        .DeploymentStrategyId(impl.deploymentStrategyId())
    override val configurationProfileId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.configurationProfileId())
    override val configurationVersion: Version =
      zio.aws.appconfig.model.primitives.Version(impl.configurationVersion())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appconfig.model.primitives
              .TagKey(key) -> zio.aws.appconfig.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest
  ): zio.aws.appconfig.model.StartDeploymentRequest.ReadOnly = new Wrapper(impl)
}
