package zio.aws.appconfig
import zio.aws.appconfig.model.primitives.TagKey.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.appconfig.model.primitives.{TagValue, TagKey}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.appconfig.model.primitives.Arn.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.appconfig.model.primitives.Blob.Type
    object ConfigurationProfileType extends Subtype[String]
    type ConfigurationProfileType =
      zio.aws.appconfig.model.primitives.ConfigurationProfileType.Type
    object DeploymentStrategyId extends Subtype[String]
    type DeploymentStrategyId =
      zio.aws.appconfig.model.primitives.DeploymentStrategyId.Type
    object Description extends Subtype[String]
    type Description = zio.aws.appconfig.model.primitives.Description.Type
    object GrowthFactor extends Subtype[Float]
    type GrowthFactor = zio.aws.appconfig.model.primitives.GrowthFactor.Type
    object Id extends Subtype[String]
    type Id = zio.aws.appconfig.model.primitives.Id.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.appconfig.model.primitives.Integer.Type
    object Iso8601DateTime extends Subtype[Instant]
    type Iso8601DateTime =
      zio.aws.appconfig.model.primitives.Iso8601DateTime.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.appconfig.model.primitives.MaxResults.Type
    object MinutesBetween0And24Hours extends Subtype[Int]
    type MinutesBetween0And24Hours =
      zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours.Type
    object Name extends Subtype[String]
    type Name = zio.aws.appconfig.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.appconfig.model.primitives.NextToken.Type
    object Percentage extends Subtype[Float]
    type Percentage = zio.aws.appconfig.model.primitives.Percentage.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.appconfig.model.primitives.RoleArn.Type
    object StringWithLengthBetween0And32768 extends Subtype[String]
    type StringWithLengthBetween0And32768 =
      zio.aws.appconfig.model.primitives.StringWithLengthBetween0And32768.Type
    object StringWithLengthBetween1And2048 extends Subtype[String]
    type StringWithLengthBetween1And2048 =
      zio.aws.appconfig.model.primitives.StringWithLengthBetween1And2048.Type
    object StringWithLengthBetween1And255 extends Subtype[String]
    type StringWithLengthBetween1And255 =
      zio.aws.appconfig.model.primitives.StringWithLengthBetween1And255.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.appconfig.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.appconfig.model.primitives.TagValue.Type
    object Uri extends Subtype[String]
    type Uri = zio.aws.appconfig.model.primitives.Uri.Type
    object Version extends Subtype[String]
    type Version = zio.aws.appconfig.model.primitives.Version.Type
  }
  type ApplicationList = List[zio.aws.appconfig.model.Application]
  type ConfigurationProfileSummaryList =
    List[zio.aws.appconfig.model.ConfigurationProfileSummary]
  type DeploymentEvents = List[zio.aws.appconfig.model.DeploymentEvent]
  type DeploymentList = List[zio.aws.appconfig.model.DeploymentSummary]
  type DeploymentStrategyList = List[zio.aws.appconfig.model.DeploymentStrategy]
  type EnvironmentList = List[zio.aws.appconfig.model.Environment]
  type HostedConfigurationVersionSummaryList =
    List[zio.aws.appconfig.model.HostedConfigurationVersionSummary]
  type MonitorList = List[zio.aws.appconfig.model.Monitor]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type ValidatorList = List[zio.aws.appconfig.model.Validator]
  type ValidatorTypeList = List[zio.aws.appconfig.model.ValidatorType]
}
