package zio.aws.appconfig
import zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.appconfig.model.{
  StopDeploymentRequest,
  UpdateApplicationRequest,
  GetEnvironmentRequest,
  GetDeploymentStrategyRequest,
  StartDeploymentRequest,
  DeleteApplicationRequest,
  ListEnvironmentsRequest,
  CreateHostedConfigurationVersionRequest,
  CreateConfigurationProfileRequest,
  UpdateEnvironmentRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  UpdateConfigurationProfileRequest,
  GetConfigurationProfileRequest,
  GetHostedConfigurationVersionRequest,
  ListHostedConfigurationVersionsRequest,
  ValidateConfigurationRequest,
  ListDeploymentsRequest,
  GetApplicationRequest,
  DeleteHostedConfigurationVersionRequest,
  UntagResourceRequest,
  UpdateDeploymentStrategyRequest,
  ListApplicationsRequest,
  CreateEnvironmentRequest,
  GetDeploymentRequest,
  DeleteConfigurationProfileRequest,
  DeleteEnvironmentRequest,
  CreateDeploymentStrategyRequest,
  DeleteDeploymentStrategyRequest,
  ListConfigurationProfilesRequest,
  TagResourceRequest,
  ListDeploymentStrategiesRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.appconfig.{
  AppConfigAsyncClientBuilder,
  AppConfigAsyncClient
}
import software.amazon.awssdk.services.appconfig.model.{
  GetHostedConfigurationVersionResponse,
  DeploymentStrategy,
  DeploymentSummary,
  GetEnvironmentResponse,
  DeleteDeploymentStrategyResponse,
  ListHostedConfigurationVersionsResponse,
  UpdateApplicationResponse,
  Application,
  ListDeploymentStrategiesResponse,
  GetDeploymentStrategyResponse,
  ConfigurationProfileSummary,
  CreateHostedConfigurationVersionResponse,
  UpdateEnvironmentResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UpdateConfigurationProfileResponse,
  CreateConfigurationProfileResponse,
  ListConfigurationProfilesResponse,
  DeleteHostedConfigurationVersionResponse,
  GetConfigurationProfileResponse,
  ListApplicationsResponse,
  HostedConfigurationVersionSummary,
  DeleteConfigurationProfileResponse,
  CreateApplicationResponse,
  StopDeploymentResponse,
  CreateDeploymentStrategyResponse,
  ListDeploymentsResponse,
  ValidateConfigurationResponse,
  StartDeploymentResponse,
  UpdateDeploymentStrategyResponse,
  TagResourceResponse,
  GetApplicationResponse,
  GetDeploymentResponse,
  ListEnvironmentsResponse,
  Environment,
  CreateEnvironmentResponse,
  DeleteApplicationResponse,
  DeleteEnvironmentResponse
}
import scala.jdk.CollectionConverters.*
trait AppConfig extends AspectSupport[AppConfig] {
  val api: AppConfigAsyncClient
  def deleteEnvironment(request: DeleteEnvironmentRequest): IO[AwsError, Unit]
  def stopDeployment(
      request: StopDeploymentRequest
  ): IO[AwsError, zio.aws.appconfig.model.StopDeploymentResponse.ReadOnly]
  def getApplication(
      request: GetApplicationRequest
  ): IO[AwsError, zio.aws.appconfig.model.GetApplicationResponse.ReadOnly]
  def deleteApplication(request: DeleteApplicationRequest): IO[AwsError, Unit]
  def createEnvironment(
      request: CreateEnvironmentRequest
  ): IO[AwsError, zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly]
  def getEnvironment(
      request: GetEnvironmentRequest
  ): IO[AwsError, zio.aws.appconfig.model.GetEnvironmentResponse.ReadOnly]
  def listDeploymentStrategies(
      request: ListDeploymentStrategiesRequest
  ): ZStream[Any, AwsError, zio.aws.appconfig.model.DeploymentStrategy.ReadOnly]
  def listDeploymentStrategiesPaginated(
      request: ListDeploymentStrategiesRequest
  ): IO[
    AwsError,
    zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly
  ]
  def getDeployment(
      request: GetDeploymentRequest
  ): IO[AwsError, zio.aws.appconfig.model.GetDeploymentResponse.ReadOnly]
  def createApplication(
      request: CreateApplicationRequest
  ): IO[AwsError, zio.aws.appconfig.model.CreateApplicationResponse.ReadOnly]
  def listDeployments(
      request: ListDeploymentsRequest
  ): ZStream[Any, AwsError, zio.aws.appconfig.model.DeploymentSummary.ReadOnly]
  def listDeploymentsPaginated(
      request: ListDeploymentsRequest
  ): IO[AwsError, zio.aws.appconfig.model.ListDeploymentsResponse.ReadOnly]
  def deleteHostedConfigurationVersion(
      request: DeleteHostedConfigurationVersionRequest
  ): IO[AwsError, Unit]
  def createConfigurationProfile(
      request: CreateConfigurationProfileRequest
  ): IO[
    AwsError,
    zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly
  ]
  def listEnvironments(
      request: ListEnvironmentsRequest
  ): ZStream[Any, AwsError, zio.aws.appconfig.model.Environment.ReadOnly]
  def listEnvironmentsPaginated(
      request: ListEnvironmentsRequest
  ): IO[AwsError, zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def validateConfiguration(
      request: ValidateConfigurationRequest
  ): IO[AwsError, Unit]
  def getDeploymentStrategy(request: GetDeploymentStrategyRequest): IO[
    AwsError,
    zio.aws.appconfig.model.GetDeploymentStrategyResponse.ReadOnly
  ]
  def getHostedConfigurationVersion(
      request: GetHostedConfigurationVersionRequest
  ): IO[
    AwsError,
    zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.appconfig.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def listApplications(
      request: ListApplicationsRequest
  ): ZStream[Any, AwsError, zio.aws.appconfig.model.Application.ReadOnly]
  def listApplicationsPaginated(
      request: ListApplicationsRequest
  ): IO[AwsError, zio.aws.appconfig.model.ListApplicationsResponse.ReadOnly]
  def createHostedConfigurationVersion(
      request: CreateHostedConfigurationVersionRequest
  ): IO[
    AwsError,
    zio.aws.appconfig.model.CreateHostedConfigurationVersionResponse.ReadOnly
  ]
  def updateEnvironment(
      request: UpdateEnvironmentRequest
  ): IO[AwsError, zio.aws.appconfig.model.UpdateEnvironmentResponse.ReadOnly]
  def deleteConfigurationProfile(
      request: DeleteConfigurationProfileRequest
  ): IO[AwsError, Unit]
  def listConfigurationProfiles(
      request: ListConfigurationProfilesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly
  ]
  def listConfigurationProfilesPaginated(
      request: ListConfigurationProfilesRequest
  ): IO[
    AwsError,
    zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly
  ]
  def updateApplication(
      request: UpdateApplicationRequest
  ): IO[AwsError, zio.aws.appconfig.model.UpdateApplicationResponse.ReadOnly]
  def updateConfigurationProfile(
      request: UpdateConfigurationProfileRequest
  ): IO[
    AwsError,
    zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly
  ]
  def deleteDeploymentStrategy(
      request: DeleteDeploymentStrategyRequest
  ): IO[AwsError, Unit]
  def updateDeploymentStrategy(request: UpdateDeploymentStrategyRequest): IO[
    AwsError,
    zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly
  ]
  def startDeployment(
      request: StartDeploymentRequest
  ): IO[AwsError, zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly]
  def listHostedConfigurationVersions(
      request: ListHostedConfigurationVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly
  ]
  def listHostedConfigurationVersionsPaginated(
      request: ListHostedConfigurationVersionsRequest
  ): IO[AwsError, ReadOnly]
  def createDeploymentStrategy(request: CreateDeploymentStrategyRequest): IO[
    AwsError,
    zio.aws.appconfig.model.CreateDeploymentStrategyResponse.ReadOnly
  ]
  def getConfigurationProfile(request: GetConfigurationProfileRequest): IO[
    AwsError,
    zio.aws.appconfig.model.GetConfigurationProfileResponse.ReadOnly
  ]
}
object AppConfig {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AppConfig] = customized(
    identity
  )
  def customized(
      customization: AppConfigAsyncClientBuilder => AppConfigAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AppConfig] = managed(
    customization
  ).toLayer
  def managed(
      customization: AppConfigAsyncClientBuilder => AppConfigAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AppConfig] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AppConfigAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AppConfigAsyncClient, AppConfigAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[AppConfigAsyncClient, AppConfigAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new AppConfigImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AppConfigImpl[R](
      override val api: AppConfigAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AppConfig
      with AwsServiceBase[R] {
    override val serviceName: String = "AppConfig"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppConfigImpl[R1] = new AppConfigImpl(api, newAspect, r)
    def deleteEnvironment(
        request: DeleteEnvironmentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.DeleteEnvironmentRequest,
      DeleteEnvironmentResponse
    ]("deleteEnvironment", api.deleteEnvironment)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def stopDeployment(
        request: StopDeploymentRequest
    ): IO[AwsError, zio.aws.appconfig.model.StopDeploymentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.StopDeploymentRequest,
        StopDeploymentResponse
      ]("stopDeployment", api.stopDeployment)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.StopDeploymentResponse.wrap)
        .provideEnvironment(r)
    def getApplication(
        request: GetApplicationRequest
    ): IO[AwsError, zio.aws.appconfig.model.GetApplicationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.GetApplicationRequest,
        GetApplicationResponse
      ]("getApplication", api.getApplication)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.GetApplicationResponse.wrap)
        .provideEnvironment(r)
    def deleteApplication(
        request: DeleteApplicationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def createEnvironment(request: CreateEnvironmentRequest): IO[
      AwsError,
      zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.CreateEnvironmentRequest,
      CreateEnvironmentResponse
    ]("createEnvironment", api.createEnvironment)(request.buildAwsValue())
      .map(zio.aws.appconfig.model.CreateEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def getEnvironment(
        request: GetEnvironmentRequest
    ): IO[AwsError, zio.aws.appconfig.model.GetEnvironmentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest,
        GetEnvironmentResponse
      ]("getEnvironment", api.getEnvironment)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.GetEnvironmentResponse.wrap)
        .provideEnvironment(r)
    def listDeploymentStrategies(
        request: ListDeploymentStrategiesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appconfig.model.DeploymentStrategy.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest,
      ListDeploymentStrategiesResponse,
      DeploymentStrategy
    ](
      "listDeploymentStrategies",
      api.listDeploymentStrategies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appconfig.model.DeploymentStrategy.wrap(item))
      .provideEnvironment(r)
    def listDeploymentStrategiesPaginated(
        request: ListDeploymentStrategiesRequest
    ): IO[
      AwsError,
      zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest,
      ListDeploymentStrategiesResponse
    ]("listDeploymentStrategies", api.listDeploymentStrategies)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.ListDeploymentStrategiesResponse.wrap)
      .provideEnvironment(r)
    def getDeployment(
        request: GetDeploymentRequest
    ): IO[AwsError, zio.aws.appconfig.model.GetDeploymentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest,
        GetDeploymentResponse
      ]("getDeployment", api.getDeployment)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.GetDeploymentResponse.wrap)
        .provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.appconfig.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.appconfig.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def listDeployments(request: ListDeploymentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.appconfig.model.DeploymentSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest,
      ListDeploymentsResponse,
      DeploymentSummary
    ](
      "listDeployments",
      api.listDeployments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appconfig.model.DeploymentSummary.wrap(item))
      .provideEnvironment(r)
    def listDeploymentsPaginated(
        request: ListDeploymentsRequest
    ): IO[AwsError, zio.aws.appconfig.model.ListDeploymentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest,
        ListDeploymentsResponse
      ]("listDeployments", api.listDeployments)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.ListDeploymentsResponse.wrap)
        .provideEnvironment(r)
    def deleteHostedConfigurationVersion(
        request: DeleteHostedConfigurationVersionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.DeleteHostedConfigurationVersionRequest,
      DeleteHostedConfigurationVersionResponse
    ]("deleteHostedConfigurationVersion", api.deleteHostedConfigurationVersion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createConfigurationProfile(
        request: CreateConfigurationProfileRequest
    ): IO[
      AwsError,
      zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.CreateConfigurationProfileRequest,
      CreateConfigurationProfileResponse
    ]("createConfigurationProfile", api.createConfigurationProfile)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.CreateConfigurationProfileResponse.wrap)
      .provideEnvironment(r)
    def listEnvironments(
        request: ListEnvironmentsRequest
    ): ZStream[Any, AwsError, zio.aws.appconfig.model.Environment.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest,
        ListEnvironmentsResponse,
        Environment
      ](
        "listEnvironments",
        api.listEnvironments,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appconfig.model.Environment.wrap(item))
        .provideEnvironment(r)
    def listEnvironmentsPaginated(
        request: ListEnvironmentsRequest
    ): IO[AwsError, zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest,
        ListEnvironmentsResponse
      ]("listEnvironments", api.listEnvironments)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.ListEnvironmentsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def validateConfiguration(
        request: ValidateConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.ValidateConfigurationRequest,
      ValidateConfigurationResponse
    ]("validateConfiguration", api.validateConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getDeploymentStrategy(request: GetDeploymentStrategyRequest): IO[
      AwsError,
      zio.aws.appconfig.model.GetDeploymentStrategyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.GetDeploymentStrategyRequest,
      GetDeploymentStrategyResponse
    ]("getDeploymentStrategy", api.getDeploymentStrategy)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.GetDeploymentStrategyResponse.wrap)
      .provideEnvironment(r)
    def getHostedConfigurationVersion(
        request: GetHostedConfigurationVersionRequest
    ): IO[
      AwsError,
      zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.GetHostedConfigurationVersionRequest,
      GetHostedConfigurationVersionResponse
    ]("getHostedConfigurationVersion", api.getHostedConfigurationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.appconfig.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.appconfig.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listApplications(
        request: ListApplicationsRequest
    ): ZStream[Any, AwsError, zio.aws.appconfig.model.Application.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest,
        ListApplicationsResponse,
        Application
      ](
        "listApplications",
        api.listApplications,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.items().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.appconfig.model.Application.wrap(item))
        .provideEnvironment(r)
    def listApplicationsPaginated(
        request: ListApplicationsRequest
    ): IO[AwsError, zio.aws.appconfig.model.ListApplicationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.ListApplicationsRequest,
        ListApplicationsResponse
      ]("listApplications", api.listApplications)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.ListApplicationsResponse.wrap)
        .provideEnvironment(r)
    def createHostedConfigurationVersion(
        request: CreateHostedConfigurationVersionRequest
    ): IO[
      AwsError,
      zio.aws.appconfig.model.CreateHostedConfigurationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.CreateHostedConfigurationVersionRequest,
      CreateHostedConfigurationVersionResponse
    ]("createHostedConfigurationVersion", api.createHostedConfigurationVersion)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.CreateHostedConfigurationVersionResponse.wrap)
      .provideEnvironment(r)
    def updateEnvironment(request: UpdateEnvironmentRequest): IO[
      AwsError,
      zio.aws.appconfig.model.UpdateEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.UpdateEnvironmentRequest,
      UpdateEnvironmentResponse
    ]("updateEnvironment", api.updateEnvironment)(request.buildAwsValue())
      .map(zio.aws.appconfig.model.UpdateEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def deleteConfigurationProfile(
        request: DeleteConfigurationProfileRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.DeleteConfigurationProfileRequest,
      DeleteConfigurationProfileResponse
    ]("deleteConfigurationProfile", api.deleteConfigurationProfile)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listConfigurationProfiles(
        request: ListConfigurationProfilesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest,
      ListConfigurationProfilesResponse,
      ConfigurationProfileSummary
    ](
      "listConfigurationProfiles",
      api.listConfigurationProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.appconfig.model.ConfigurationProfileSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listConfigurationProfilesPaginated(
        request: ListConfigurationProfilesRequest
    ): IO[
      AwsError,
      zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesRequest,
      ListConfigurationProfilesResponse
    ]("listConfigurationProfiles", api.listConfigurationProfiles)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.ListConfigurationProfilesResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(request: UpdateApplicationRequest): IO[
      AwsError,
      zio.aws.appconfig.model.UpdateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(zio.aws.appconfig.model.UpdateApplicationResponse.wrap)
      .provideEnvironment(r)
    def updateConfigurationProfile(
        request: UpdateConfigurationProfileRequest
    ): IO[
      AwsError,
      zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.UpdateConfigurationProfileRequest,
      UpdateConfigurationProfileResponse
    ]("updateConfigurationProfile", api.updateConfigurationProfile)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.UpdateConfigurationProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteDeploymentStrategy(
        request: DeleteDeploymentStrategyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.DeleteDeploymentStrategyRequest,
      DeleteDeploymentStrategyResponse
    ]("deleteDeploymentStrategy", api.deleteDeploymentStrategy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateDeploymentStrategy(request: UpdateDeploymentStrategyRequest): IO[
      AwsError,
      zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.UpdateDeploymentStrategyRequest,
      UpdateDeploymentStrategyResponse
    ]("updateDeploymentStrategy", api.updateDeploymentStrategy)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.wrap)
      .provideEnvironment(r)
    def startDeployment(
        request: StartDeploymentRequest
    ): IO[AwsError, zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.appconfig.model.StartDeploymentRequest,
        StartDeploymentResponse
      ]("startDeployment", api.startDeployment)(request.buildAwsValue())
        .map(zio.aws.appconfig.model.StartDeploymentResponse.wrap)
        .provideEnvironment(r)
    def listHostedConfigurationVersions(
        request: ListHostedConfigurationVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest,
      ListHostedConfigurationVersionsResponse,
      HostedConfigurationVersionSummary
    ](
      "listHostedConfigurationVersions",
      api.listHostedConfigurationVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.appconfig.model.HostedConfigurationVersionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listHostedConfigurationVersionsPaginated(
        request: ListHostedConfigurationVersionsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest,
      ListHostedConfigurationVersionsResponse
    ]("listHostedConfigurationVersions", api.listHostedConfigurationVersions)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse.wrap)
      .provideEnvironment(r)
    def createDeploymentStrategy(request: CreateDeploymentStrategyRequest): IO[
      AwsError,
      zio.aws.appconfig.model.CreateDeploymentStrategyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.CreateDeploymentStrategyRequest,
      CreateDeploymentStrategyResponse
    ]("createDeploymentStrategy", api.createDeploymentStrategy)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.CreateDeploymentStrategyResponse.wrap)
      .provideEnvironment(r)
    def getConfigurationProfile(request: GetConfigurationProfileRequest): IO[
      AwsError,
      zio.aws.appconfig.model.GetConfigurationProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appconfig.model.GetConfigurationProfileRequest,
      GetConfigurationProfileResponse
    ]("getConfigurationProfile", api.getConfigurationProfile)(
      request.buildAwsValue()
    ).map(zio.aws.appconfig.model.GetConfigurationProfileResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteEnvironment(
      request: DeleteEnvironmentRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteEnvironment(request))
  def stopDeployment(request: StopDeploymentRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.StopDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDeployment(request))
  def getApplication(request: GetApplicationRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def deleteApplication(
      request: DeleteApplicationRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteApplication(request))
  def createEnvironment(request: CreateEnvironmentRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.CreateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEnvironment(request))
  def getEnvironment(request: GetEnvironmentRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.GetEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEnvironment(request))
  def listDeploymentStrategies(
      request: ListDeploymentStrategiesRequest
  ): ZStream[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.DeploymentStrategy.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeploymentStrategies(request))
  def listDeploymentStrategiesPaginated(
      request: ListDeploymentStrategiesRequest
  ): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeploymentStrategiesPaginated(request))
  def getDeployment(request: GetDeploymentRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.GetDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeployment(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def listDeployments(request: ListDeploymentsRequest): ZStream[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.DeploymentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeployments(request))
  def listDeploymentsPaginated(request: ListDeploymentsRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.ListDeploymentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeploymentsPaginated(request))
  def deleteHostedConfigurationVersion(
      request: DeleteHostedConfigurationVersionRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteHostedConfigurationVersion(request))
  def createConfigurationProfile(
      request: CreateConfigurationProfileRequest
  ): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.CreateConfigurationProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationProfile(request))
  def listEnvironments(request: ListEnvironmentsRequest): ZStream[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.Environment.ReadOnly
  ] = ZStream.serviceWithStream(_.listEnvironments(request))
  def listEnvironmentsPaginated(request: ListEnvironmentsRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.ListEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEnvironmentsPaginated(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def validateConfiguration(
      request: ValidateConfigurationRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.validateConfiguration(request))
  def getDeploymentStrategy(request: GetDeploymentStrategyRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.GetDeploymentStrategyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeploymentStrategy(request))
  def getHostedConfigurationVersion(
      request: GetHostedConfigurationVersionRequest
  ): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.GetHostedConfigurationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHostedConfigurationVersion(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(request: ListApplicationsRequest): ZStream[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.Application.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(request: ListApplicationsRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def createHostedConfigurationVersion(
      request: CreateHostedConfigurationVersionRequest
  ): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.CreateHostedConfigurationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHostedConfigurationVersion(request))
  def updateEnvironment(request: UpdateEnvironmentRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.UpdateEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEnvironment(request))
  def deleteConfigurationProfile(
      request: DeleteConfigurationProfileRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteConfigurationProfile(request))
  def listConfigurationProfiles(
      request: ListConfigurationProfilesRequest
  ): ZStream[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listConfigurationProfiles(request))
  def listConfigurationProfilesPaginated(
      request: ListConfigurationProfilesRequest
  ): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigurationProfilesPaginated(request))
  def updateApplication(request: UpdateApplicationRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def updateConfigurationProfile(
      request: UpdateConfigurationProfileRequest
  ): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.UpdateConfigurationProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfigurationProfile(request))
  def deleteDeploymentStrategy(
      request: DeleteDeploymentStrategyRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDeploymentStrategy(request))
  def updateDeploymentStrategy(request: UpdateDeploymentStrategyRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.UpdateDeploymentStrategyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeploymentStrategy(request))
  def startDeployment(request: StartDeploymentRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.StartDeploymentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDeployment(request))
  def listHostedConfigurationVersions(
      request: ListHostedConfigurationVersionsRequest
  ): ZStream[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listHostedConfigurationVersions(request))
  def listHostedConfigurationVersionsPaginated(
      request: ListHostedConfigurationVersionsRequest
  ): ZIO[zio.aws.appconfig.AppConfig, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listHostedConfigurationVersionsPaginated(request))
  def createDeploymentStrategy(request: CreateDeploymentStrategyRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.CreateDeploymentStrategyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeploymentStrategy(request))
  def getConfigurationProfile(request: GetConfigurationProfileRequest): ZIO[
    zio.aws.appconfig.AppConfig,
    AwsError,
    zio.aws.appconfig.model.GetConfigurationProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfigurationProfile(request))
}
