package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{
  ConfigurationProfileType,
  Uri,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConfigurationProfileSummary(
    applicationId: Option[Id] = None,
    id: Option[Id] = None,
    name: Option[Name] = None,
    locationUri: Option[Uri] = None,
    validatorTypes: Option[Iterable[zio.aws.appconfig.model.ValidatorType]] =
      None,
    `type`: Option[ConfigurationProfileType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary = {
    import ConfigurationProfileSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        locationUri.map(value => Uri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        validatorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.validatorTypesWithStrings)
      .optionallyWith(
        `type`.map(value =>
          ConfigurationProfileType.unwrap(value): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly =
    zio.aws.appconfig.model.ConfigurationProfileSummary.wrap(buildAwsValue())
}
object ConfigurationProfileSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ConfigurationProfileSummary =
      zio.aws.appconfig.model.ConfigurationProfileSummary(
        applicationId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        locationUri.map(value => value),
        validatorTypes.map(value => value),
        `type`.map(value => value)
      )
    def applicationId: Option[Id]
    def id: Option[Id]
    def name: Option[Name]
    def locationUri: Option[Uri]
    def validatorTypes: Option[List[zio.aws.appconfig.model.ValidatorType]]
    def `type`: Option[ConfigurationProfileType]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getLocationUri: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getValidatorTypes
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.ValidatorType]] =
      AwsError.unwrapOptionField("validatorTypes", validatorTypes)
    def getType: ZIO[Any, AwsError, ConfigurationProfileType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
  ) extends zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly {
    override val applicationId: Option[Id] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val locationUri: Option[Uri] = scala
      .Option(impl.locationUri())
      .map(value => zio.aws.appconfig.model.primitives.Uri(value))
    override val validatorTypes
        : Option[List[zio.aws.appconfig.model.ValidatorType]] = scala
      .Option(impl.validatorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.ValidatorType.wrap(item)
        }.toList
      )
    override val `type`: Option[ConfigurationProfileType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.appconfig.model.primitives.ConfigurationProfileType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ConfigurationProfileSummary
  ): zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly = new Wrapper(
    impl
  )
}
