package zio.aws.appconfig.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.appconfig.model.primitives.{
  Percentage,
  MinutesBetween0And24Hours,
  Iso8601DateTime,
  Version,
  Name
}
import scala.jdk.CollectionConverters.*
final case class DeploymentSummary(
    deploymentNumber: Option[zio.aws.appconfig.model.primitives.Integer] = None,
    configurationName: Option[Name] = None,
    configurationVersion: Option[Version] = None,
    deploymentDurationInMinutes: Option[MinutesBetween0And24Hours] = None,
    growthType: Option[zio.aws.appconfig.model.GrowthType] = None,
    growthFactor: Option[Percentage] = None,
    finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] = None,
    state: Option[zio.aws.appconfig.model.DeploymentState] = None,
    percentageComplete: Option[Percentage] = None,
    startedAt: Option[Iso8601DateTime] = None,
    completedAt: Option[Iso8601DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.DeploymentSummary = {
    import DeploymentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.DeploymentSummary
      .builder()
      .optionallyWith(deploymentNumber.map(value => value: Integer))(
        _.deploymentNumber
      )
      .optionallyWith(
        configurationName.map(value => Name.unwrap(value): java.lang.String)
      )(_.configurationName)
      .optionallyWith(
        configurationVersion.map(value =>
          Version.unwrap(value): java.lang.String
        )
      )(_.configurationVersion)
      .optionallyWith(
        deploymentDurationInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.deploymentDurationInMinutes)
      .optionallyWith(growthType.map(value => value.unwrap))(_.growthType)
      .optionallyWith(
        growthFactor.map(value => Percentage.unwrap(value): java.lang.Float)
      )(_.growthFactor)
      .optionallyWith(
        finalBakeTimeInMinutes.map(value =>
          MinutesBetween0And24Hours.unwrap(value): Integer
        )
      )(_.finalBakeTimeInMinutes)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        percentageComplete.map(value =>
          Percentage.unwrap(value): java.lang.Float
        )
      )(_.percentageComplete)
      .optionallyWith(
        startedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.startedAt)
      .optionallyWith(
        completedAt.map(value => Iso8601DateTime.unwrap(value): Instant)
      )(_.completedAt)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.DeploymentSummary.ReadOnly =
    zio.aws.appconfig.model.DeploymentSummary.wrap(buildAwsValue())
}
object DeploymentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.DeploymentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.DeploymentSummary =
      zio.aws.appconfig.model.DeploymentSummary(
        deploymentNumber.map(value => value),
        configurationName.map(value => value),
        configurationVersion.map(value => value),
        deploymentDurationInMinutes.map(value => value),
        growthType.map(value => value),
        growthFactor.map(value => value),
        finalBakeTimeInMinutes.map(value => value),
        state.map(value => value),
        percentageComplete.map(value => value),
        startedAt.map(value => value),
        completedAt.map(value => value)
      )
    def deploymentNumber: Option[zio.aws.appconfig.model.primitives.Integer]
    def configurationName: Option[Name]
    def configurationVersion: Option[Version]
    def deploymentDurationInMinutes: Option[MinutesBetween0And24Hours]
    def growthType: Option[zio.aws.appconfig.model.GrowthType]
    def growthFactor: Option[Percentage]
    def finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours]
    def state: Option[zio.aws.appconfig.model.DeploymentState]
    def percentageComplete: Option[Percentage]
    def startedAt: Option[Iso8601DateTime]
    def completedAt: Option[Iso8601DateTime]
    def getDeploymentNumber
        : ZIO[Any, AwsError, zio.aws.appconfig.model.primitives.Integer] =
      AwsError.unwrapOptionField("deploymentNumber", deploymentNumber)
    def getConfigurationName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("configurationName", configurationName)
    def getConfigurationVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("configurationVersion", configurationVersion)
    def getDeploymentDurationInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] =
      AwsError.unwrapOptionField(
        "deploymentDurationInMinutes",
        deploymentDurationInMinutes
      )
    def getGrowthType: ZIO[Any, AwsError, zio.aws.appconfig.model.GrowthType] =
      AwsError.unwrapOptionField("growthType", growthType)
    def getGrowthFactor: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("growthFactor", growthFactor)
    def getFinalBakeTimeInMinutes
        : ZIO[Any, AwsError, MinutesBetween0And24Hours] = AwsError
      .unwrapOptionField("finalBakeTimeInMinutes", finalBakeTimeInMinutes)
    def getState: ZIO[Any, AwsError, zio.aws.appconfig.model.DeploymentState] =
      AwsError.unwrapOptionField("state", state)
    def getPercentageComplete: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("percentageComplete", percentageComplete)
    def getStartedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getCompletedAt: ZIO[Any, AwsError, Iso8601DateTime] =
      AwsError.unwrapOptionField("completedAt", completedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentSummary
  ) extends zio.aws.appconfig.model.DeploymentSummary.ReadOnly {
    override val deploymentNumber
        : Option[zio.aws.appconfig.model.primitives.Integer] = scala
      .Option(impl.deploymentNumber())
      .map(value => value: zio.aws.appconfig.model.primitives.Integer)
    override val configurationName: Option[Name] = scala
      .Option(impl.configurationName())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val configurationVersion: Option[Version] = scala
      .Option(impl.configurationVersion())
      .map(value => zio.aws.appconfig.model.primitives.Version(value))
    override val deploymentDurationInMinutes
        : Option[MinutesBetween0And24Hours] = scala
      .Option(impl.deploymentDurationInMinutes())
      .map(value =>
        zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
      )
    override val growthType: Option[zio.aws.appconfig.model.GrowthType] = scala
      .Option(impl.growthType())
      .map(value => zio.aws.appconfig.model.GrowthType.wrap(value))
    override val growthFactor: Option[Percentage] = scala
      .Option(impl.growthFactor())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val finalBakeTimeInMinutes: Option[MinutesBetween0And24Hours] =
      scala
        .Option(impl.finalBakeTimeInMinutes())
        .map(value =>
          zio.aws.appconfig.model.primitives.MinutesBetween0And24Hours(value)
        )
    override val state: Option[zio.aws.appconfig.model.DeploymentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.appconfig.model.DeploymentState.wrap(value))
    override val percentageComplete: Option[Percentage] = scala
      .Option(impl.percentageComplete())
      .map(value => zio.aws.appconfig.model.primitives.Percentage(value))
    override val startedAt: Option[Iso8601DateTime] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
    override val completedAt: Option[Iso8601DateTime] = scala
      .Option(impl.completedAt())
      .map(value => zio.aws.appconfig.model.primitives.Iso8601DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.DeploymentSummary
  ): zio.aws.appconfig.model.DeploymentSummary.ReadOnly = new Wrapper(impl)
}
