package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Description, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Environment(
    applicationId: Option[Id] = None,
    id: Option[Id] = None,
    name: Option[Name] = None,
    description: Option[Description] = None,
    state: Option[zio.aws.appconfig.model.EnvironmentState] = None,
    monitors: Option[Iterable[zio.aws.appconfig.model.Monitor]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.Environment = {
    import Environment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.Environment
      .builder()
      .optionallyWith(
        applicationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        monitors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.monitors)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.Environment.ReadOnly =
    zio.aws.appconfig.model.Environment.wrap(buildAwsValue())
}
object Environment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.Environment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.Environment =
      zio.aws.appconfig.model.Environment(
        applicationId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        state.map(value => value),
        monitors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationId: Option[Id]
    def id: Option[Id]
    def name: Option[Name]
    def description: Option[Description]
    def state: Option[zio.aws.appconfig.model.EnvironmentState]
    def monitors: Option[List[zio.aws.appconfig.model.Monitor.ReadOnly]]
    def getApplicationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getState: ZIO[Any, AwsError, zio.aws.appconfig.model.EnvironmentState] =
      AwsError.unwrapOptionField("state", state)
    def getMonitors
        : ZIO[Any, AwsError, List[zio.aws.appconfig.model.Monitor.ReadOnly]] =
      AwsError.unwrapOptionField("monitors", monitors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.Environment
  ) extends zio.aws.appconfig.model.Environment.ReadOnly {
    override val applicationId: Option[Id] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
    override val state: Option[zio.aws.appconfig.model.EnvironmentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.appconfig.model.EnvironmentState.wrap(value))
    override val monitors
        : Option[List[zio.aws.appconfig.model.Monitor.ReadOnly]] = scala
      .Option(impl.monitors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.Monitor.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.Environment
  ): zio.aws.appconfig.model.Environment.ReadOnly = new Wrapper(impl)
}
