package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{Description, Name, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetApplicationResponse(
    id: Option[Id] = None,
    name: Option[Name] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetApplicationResponse = {
    import GetApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetApplicationResponse
      .builder()
      .optionallyWith(id.map(value => Id.unwrap(value): java.lang.String))(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.GetApplicationResponse.ReadOnly =
    zio.aws.appconfig.model.GetApplicationResponse.wrap(buildAwsValue())
}
object GetApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetApplicationResponse =
      zio.aws.appconfig.model.GetApplicationResponse(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def id: Option[Id]
    def name: Option[Name]
    def description: Option[Description]
    def getId: ZIO[Any, AwsError, Id] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetApplicationResponse
  ) extends zio.aws.appconfig.model.GetApplicationResponse.ReadOnly {
    override val id: Option[Id] = scala
      .Option(impl.id())
      .map(value => zio.aws.appconfig.model.primitives.Id(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appconfig.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appconfig.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetApplicationResponse
  ): zio.aws.appconfig.model.GetApplicationResponse.ReadOnly = new Wrapper(impl)
}
