package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentRequest(applicationId: Id, environmentId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest = {
    import GetEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest
      .builder()
      .applicationId(Id.unwrap(applicationId): java.lang.String)
      .environmentId(Id.unwrap(environmentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appconfig.model.GetEnvironmentRequest.ReadOnly =
    zio.aws.appconfig.model.GetEnvironmentRequest.wrap(buildAwsValue())
}
object GetEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.GetEnvironmentRequest =
      zio.aws.appconfig.model
        .GetEnvironmentRequest(applicationId, environmentId)
    def applicationId: Id
    def environmentId: Id
    def getApplicationId: ZIO[Any, Nothing, Id] = ZIO.succeed(applicationId)
    def getEnvironmentId: ZIO[Any, Nothing, Id] = ZIO.succeed(environmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest
  ) extends zio.aws.appconfig.model.GetEnvironmentRequest.ReadOnly {
    override val applicationId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.applicationId())
    override val environmentId: Id =
      zio.aws.appconfig.model.primitives.Id(impl.environmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest
  ): zio.aws.appconfig.model.GetEnvironmentRequest.ReadOnly = new Wrapper(impl)
}
