package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConfigurationProfilesResponse(
    items: Option[
      Iterable[zio.aws.appconfig.model.ConfigurationProfileSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse = {
    import ListConfigurationProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly =
    zio.aws.appconfig.model.ListConfigurationProfilesResponse
      .wrap(buildAwsValue())
}
object ListConfigurationProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListConfigurationProfilesResponse =
      zio.aws.appconfig.model.ListConfigurationProfilesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[
      List[zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse
  ) extends zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly {
    override val items: Option[
      List[zio.aws.appconfig.model.ConfigurationProfileSummary.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.ConfigurationProfileSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListConfigurationProfilesResponse
  ): zio.aws.appconfig.model.ListConfigurationProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
