package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDeploymentStrategiesRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest = {
    import ListDeploymentStrategiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListDeploymentStrategiesRequest.ReadOnly =
    zio.aws.appconfig.model.ListDeploymentStrategiesRequest
      .wrap(buildAwsValue())
}
object ListDeploymentStrategiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListDeploymentStrategiesRequest =
      zio.aws.appconfig.model.ListDeploymentStrategiesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest
  ) extends zio.aws.appconfig.model.ListDeploymentStrategiesRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appconfig.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest
  ): zio.aws.appconfig.model.ListDeploymentStrategiesRequest.ReadOnly =
    new Wrapper(impl)
}
