package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDeploymentStrategiesResponse(
    items: Option[Iterable[zio.aws.appconfig.model.DeploymentStrategy]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse = {
    import ListDeploymentStrategiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly =
    zio.aws.appconfig.model.ListDeploymentStrategiesResponse
      .wrap(buildAwsValue())
}
object ListDeploymentStrategiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appconfig.model.ListDeploymentStrategiesResponse =
      zio.aws.appconfig.model.ListDeploymentStrategiesResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[List[zio.aws.appconfig.model.DeploymentStrategy.ReadOnly]]
    def nextToken: Option[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.DeploymentStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse
  ) extends zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly {
    override val items
        : Option[List[zio.aws.appconfig.model.DeploymentStrategy.ReadOnly]] =
      scala
        .Option(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appconfig.model.DeploymentStrategy.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse
  ): zio.aws.appconfig.model.ListDeploymentStrategiesResponse.ReadOnly =
    new Wrapper(impl)
}
