package zio.aws.appconfig.model
import zio.aws.appconfig.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListHostedConfigurationVersionsResponse(
    items: Option[
      Iterable[zio.aws.appconfig.model.HostedConfigurationVersionSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse = {
    import ListHostedConfigurationVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse.ReadOnly =
    zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse
      .wrap(buildAwsValue())
}
object ListHostedConfigurationVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse =
      zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Option[
      List[zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse
  ) extends zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse.ReadOnly {
    override val items: Option[
      List[zio.aws.appconfig.model.HostedConfigurationVersionSummary.ReadOnly]
    ] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appconfig.model.HostedConfigurationVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appconfig.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse
  ): zio.aws.appconfig.model.ListHostedConfigurationVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
